package gov.va.caret.service.ctssh.response;



import org.w3c.dom.Node;

import gov.va.caret.service.ctssh.template.TemplateResponseProperty;
import gov.va.caret.service.ctssh.util.AppHelper;


public class ResponseProperty {

	/**
	 * 
	 */
	String _path = null;
	/**
	 * 
	 */
	String _value = null;
	/**
	 * 
	 */
	String _name = null;
	
	
	/**
	 * @param tprop
	 * @param return_doc
	 * @throws Exception
	 */
	public ResponseProperty(TemplateResponseProperty tprop, Node return_doc) throws Exception
	{
	
		_name = tprop.name();
		_path = tprop.xpath();
		_value = AppHelper.getStringValue(_path, return_doc);
		
		
		
		
		if(tprop.action() != null && tprop.action().intern() == "[error]" && _value.length() > 0)
			throw new Exception(_value);
/*
		if(tprop.action() != null && tprop.action().intern() == "[decode]" && _value.length() > 0)
			_value = new String(Base64.getDecoder().decode(_value));
*/
	
		if(_value == null)
			_value = "N/F";
		
		
	}
	
	/**
	 * @return
	 */
	public String name()
	{
		return _name;
	}
	
	/**
	 * @return
	 */
	public String path() 
	{
		return _path;
	}
	
	/**
	 * @return
	 */
	public String value() 
	{
		return _value;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		return _name + " : " + _value;
	}
	
}
